turtles-own 
[
  ideal-temp
  output-heat
  unhappiness
]

patches-own
[
  temp
]

to setup
  clear-all
  ;; creating the bugs the following way ensures that we won't
  ;; wind up with more than one bug on a patch
  ask random-n-of bug-count patches [
    sprout 1 [
      set color green
      set ideal-temp  min-ideal-temp  + random abs (max-ideal-temp  - min-ideal-temp )
      set output-heat min-output-heat + random abs (max-output-heat - min-output-heat)
      set unhappiness abs (ideal-temp - temp)
    ]
  ]
  ;; plot the initial state of the system
  plot mean values-from turtles [unhappiness]
end

to go
  if not any? turtles [ stop ]
  ;; diffuse heat through world
  diffuse temp diffusion-rate
  ask turtles [
    ;; we must use without-interruption to prevent two turtles
    ;; from ever ending up on the same patch
    without-interruption [
      step
    ]
  ]
  recolor-patches
  plot mean values-from turtles [unhappiness]
end

to recolor-patches
  ask patches
  [ 
    ;; the world retains a percentage of its heat each cycle
    set temp temp * (1 - evaporation-rate)
    ;; hotter patches will be red turning to white, cooler patches will be black
    set pcolor scale-color red temp 0 150
  ]
end

to step  ;; turtle procedure
  ;; my unhappiness is the magnitude or absolute value of the difference
  ;; between by ideal temperature and the temperature of this patch
  set unhappiness abs (ideal-temp - temp)
  ;; if unhappy and not at the hottest neighbor8
  ;; then move to an open neighbor (trying random ones up to 10 times)
  ifelse unhappiness = 0
    [ set temp temp + output-heat ]
    [ let target find-target
      if (patch-here != target) or (random-move-chance > random 100)
        [ bug-move target ]
      set temp temp + output-heat
    ]
end

;; find the hottest or coolest location next to me
to-report find-target  ;; turtle procedure
  ifelse temp < ideal-temp
    [ report max-one-of neighbors [temp] ]
    [ report min-one-of neighbors [temp] ]
end

to bug-move [target]  ;; turtle procedure
  let tries 0
  ;; move to the hottest (or coolest location if I'm too hot) location next to me
  ;; if it is not occupied by another bug
  if not any? turtles-on target [
    setxy (pxcor-of target) (pycor-of target)
    stop
  ]
  ;; If I can't get to the best spot, then I try the others randomly
  ;; I only try 9 times, since there are only nine spots around me.
  ;; Even then, I might try a spot more than once.
  while [tries <= 9]
    [ set tries tries + 1
      set target random-one-of neighbors
      if not any? turtles-on target [
        setxy (pxcor-of target) (pycor-of target)
        stop
      ]
    ]
end  

;;; the following procedures support the two extra buttons
;;; in the interface

;; remove all heat from the world
to deep-freeze
  ask patches [ set temp 0 ]
end

;; add max-output-heat to all locations in the world, heating it evenly
to heat-up
  ask patches [ set temp temp + max-output-heat ]
end


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS and INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) -- grant numbers 
; REC #9814682 and REC-0126227.
;
; Copyright 2004 by Uri Wilensky.  Updated 2004.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2004).  NetLogo Heatbugs model.
; http://ccl.northwestern.edu/netlogo/models/Heatbugs.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2004 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Heatbugs
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
373
10
686
344
50
50
3.0
0
10
1
1
1
0

CC-WINDOW
5
520
695
615
Command Center

SLIDER
14
41
276
74
bug-count
bug-count
10
500
200
10
1
bugs

BUTTON
27
188
96
221
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
98
188
166
221
NIL
go
T
1
T
OBSERVER
T
NIL

SLIDER
18
305
211
338
evaporation-rate
evaporation-rate
0
1
0.02
0.01
1
NIL

SLIDER
18
339
211
372
diffusion-rate
diffusion-rate
0
1
1.0
0.1
1
NIL

SLIDER
18
374
211
407
random-move-chance
random-move-chance
0
100
1.0
1.0
1
%

PLOT
373
347
686
506
Avg. Bug Unhappiness
time
unhappiness
0.0
100.0
0.0
10.0
true
false

SLIDER
14
80
186
113
min-ideal-temp
min-ideal-temp
0
200
0.0
1.0
1
NIL

SLIDER
14
113
186
146
max-ideal-temp
max-ideal-temp
0
200
100.0
1.0
1
NIL

SLIDER
189
113
362
146
max-output-heat
max-output-heat
0
100
30.0
1.0
1
NIL

SLIDER
189
80
362
113
min-output-heat
min-output-heat
0
100
10.0
1.0
1
NIL

BUTTON
195
188
312
221
NIL
deep-freeze
NIL
1
T
OBSERVER
T
NIL

BUTTON
195
222
312
255
NIL
heat-up
NIL
1
T
OBSERVER
T
NIL

TEXTBOX
10
21
160
39
Initial settings for bugs

TEXTBOX
11
273
164
301
Other parameters (OK to change during run)

TEXTBOX
12
167
162
185
Actions

@#$#@#$#@
WHAT IS IT?
-----------
Heatbugs demonstrates how simple rules defining the behavior of agents can produce several different kinds of emergent behavior.  It has been used as a demonstration model for many agent-based modeling toolkits.


HOW IT WORKS
------------
The bugs move around on a grid of square "patches".  A bug may not move to a patch that already has another bug on it.

Each bug radiates a small amount of heat.  Heat gradually diffuses through the world; some heat is lost to cooling.

Each bug has an "ideal" temperature it wants to be.  The bigger the difference between the temperature of the patch where the bug is and the bug's ideal temperature, the more "unhappy" the bug is.  When a bug is unhappy, it moves.  If it is too hot, it moves to the coolest adjacent empty patch.  Conversely, if a bug is too cold, it moves to the warmest adjacent empty patch.  (Note that these bugs aren't smart enough to always move to the best available patch.)  


HOW TO USE IT
-------------
After choosing the number of bugs to create, and setting the model variables, press the GO button to set the heatbugs into motion.

BUG-COUNT: The number of bugs that will inhabit the model

EVAPORATION-RATE: The percentage of the world's heat that evaporates each cycle.  A lower number means a world which cools slowly, a higher number is a world which cools quickly.

DIFFUSION-RATE: How much heat a patch (a spot in the world) diffuses to it's neighbors.  A higher number means that heat diffuses thru the world quickly.  A lower number means that patches retain more of their heat.

MIN/MAX-IDEAL-TEMP: The minimum and maximum ideal temperatures for heatbugs.  Each bug is given an ideal temperature between the min and max ideal temperature.

MIN/MAX-OUTPUT-HEAT: The minimum and maximum heat that heatbugs generate each cycle.  Each bug is given a output-heat value between the min and max output heat.

RANDOM-MOVE-CHANCE: The chance that a bug will make a random move even if it would prefer to stay where it is (because no more ideal patch is available).

DEEP-FREEZE: This button removes all heat from the world.

HEAT-UP: This button adds MAX-OUTPUT-HEAT to every patch in the world.


THINGS TO NOTICE
----------------
Depending on their ideal temperatures, some bugs will tend to clump together, while others will tend to avoid all other bugs, and others still flutter around the edges of clumps.  All of these behaviors are affected as well by the evaporation rate.

The diffusion rate affects the cohesiveness of clumps.  If diffusion-rate is slow, many tiny clumps form.  Why?

Most interesting behaviors occur when the number of bugs, how much heat they generate, and how quickly the world cools are balanced such that excessive heat does not build up. 


THINGS TO TRY
-------------
Vary DIFFUSION-RATE.

Vary EVAPORATION-RATE in relation to the output-heat range of the bugs.

Use the HEAT-UP button to scramble clumped heatbugs and watch as they re-assemble into new clumps.



EXTENDING THE MODEL
-------------------
Randomize the amount of heat bugs generate each cycle.

Color the bugs differently according to their ideal temperatures.

Allow users to introduce heat into the system with the mouse.


NETLOGO FEATURES
----------------
The DIFFUSE command is central to this model.


RELATED MODELS
--------------
Slime


CREDITS AND REFERENCES
----------------------
Swarm version of Heatbugs -- http://www.swarm.org/examples-heatbugs.html
RePast version of Heatbugs -- http://repast.sourceforge.net/examples/index.html

To refer to this model in academic publications, please use: Wilensky, U. (2004). NetLogo Heatbugs model. http://ccl.northwestern.edu/netlogo/models/Heatbugs. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 2004 Uri Wilensky. All rights reserved. See http://ccl.northwestern.edu/netlogo/models/Heatbugs for terms of use. 
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
